<?php
include("connexion.php");

$message = '';

// BDD billets
$stmt = $db->query("SELECT * FROM billets ORDER BY date_post DESC");
$billets = $stmt->fetchAll(PDO::FETCH_ASSOC);

// BDD utilisateurs
$stmt_users = $db->query("SELECT * FROM utilisateurs");
$utilisateurs = $stmt_users->fetchAll(PDO::FETCH_ASSOC);

// BDD commentaires
$stmt_comments = $db->query("SELECT * FROM commentaires");
$commentaires = $stmt_comments->fetchAll(PDO::FETCH_ASSOC);

// ajout billet
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['ajouter_billet'])) {
    $titre = $_POST['titre'];
    $contenu = $_POST['contenu'];

    $stmt = $db->prepare("INSERT INTO billets (titre, contenu, date_post, auteur) VALUES (:titre, :contenu, NOW(), :auteur)");
    $stmt->bindValue(':titre', $titre, PDO::PARAM_STR);
    $stmt->bindValue(':contenu', $contenu, PDO::PARAM_STR);
    $stmt->bindValue(':auteur', $_SESSION['login'], PDO::PARAM_STR);
    $stmt->execute();

    $message = "Billet ajouté avec succès.";
}

// supprimer un billet
if (isset($_GET['supprimer_billet'])) {
    $billet_id = intval($_GET['supprimer_billet']);
    $stmt = $db->prepare("DELETE FROM billets WHERE id = :id");
    $stmt->bindValue(':id', $billet_id, PDO::PARAM_INT);
    $stmt->execute();

    $message = "Billet supprimé avec succès.";
}

// supprimer un utilisateur
if (isset($_GET['supprimer_utilisateur'])) {
    $utilisateur_id = intval($_GET['supprimer_utilisateur']);
    $stmt = $db->prepare("DELETE FROM utilisateurs WHERE id = :id");
    $stmt->bindValue(':id', $utilisateur_id, PDO::PARAM_INT);
    $stmt->execute();

    $message = "Utilisateur supprimé avec succès.";
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Mini Blog - Admin</title>
    <link href="CSS/admin.css" rel="stylesheet">
</head>
<body>
<header>
    <div class="logo"><a href="admin.php">ADMIN</a></div>
    <div class="nav-buttons">
        <a href="deco.php">Déconnexion</a>
    </div>
</header>

<div class="container">
    <div class="main-content">
        <div class="section ajouter-billet">
            <h2>Ajouter un nouveau billet</h2>
            <form action="admin.php" method="post">
                <label for="titre">Titre :</label>
                <input type="text" id="titre" name="titre" required style="padding-right:0px;">
                
                <label for="contenu">Contenu :</label>
                <textarea id="contenu" name="contenu" required style="padding-right:0px;"></textarea>
                
                <input type="submit" name="ajouter_billet" value="Ajouter">
            </form>
        </div>
        
        <div class="gestion-container">
            <div class="section">
                <h2>Gestion des billets</h2>
                <form action="admin.php" method="get">
                    <label for="billet">Sélectionner un billet :</label>
                    <select id="billet" name="billet_id">
                        <?php foreach ($billets as $billet) { ?>
                            <option value="<?= $billet['id'] ?>"><?= htmlspecialchars($billet['titre']) ?></option>
                        <?php } ?>
                    </select>
                    <div style="display: flex; gap: 10px;">
                        <input type="submit" name="supprimer_billet" value="Supprimer">
                        <input type="submit" formaction="modifbillet.php" value="Modifier">
                    </div>
                </form>
            </div>

            <div class="section">
                <h2>Gestion des utilisateurs</h2>
                <form action="admin.php" method="get">
                    <label for="utilisateur">Sélectionner un utilisateur :</label>
                    <select id="utilisateur" name="utilisateur_id">
                        <?php foreach ($utilisateurs as $utilisateur) { ?>
                            <option value="<?= $utilisateur['id'] ?>"><?= htmlspecialchars($utilisateur['login']) ?></option>
                        <?php } ?>
                    </select>
                    <div style="display: flex; gap: 10px;">
                        <input type="submit" name="supprimer_utilisateur" value="Supprimer">
                        <input type="submit" formaction="modifutilisateur.php" value="Modifier">
                    </div>
                </form>
            </div>

            <div class="section">
                <h2>Gestion des commentaires</h2>
                <form action="modifcommentaire.php" method="get">
                    <label for="commentaire">Sélectionner un billet :</label>
                    <select id="commentaire" name="id_billet">
                        <?php foreach ($billets as $billet) { ?>
                            <option value="<?= $billet['id'] ?>"><?= $billet['titre'] ?></option>
                        <?php } ?>
                    </select>
                    <input type="submit" value="Voir les commentaires">
                </form>
            </div>
        </div>
    </div>
</div>
</body>
</html>
 